/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.cors;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.cors.OkResponseHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        CorsConfig corsConfig = CorsConfig.withAnyOrigin().build();
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("cors", (ChannelHandler)new CorsHandler(corsConfig));
        pipeline.addLast("handler", (ChannelHandler)new OkResponseHandler());
    }
}

