/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.bytes.ByteEchoServerHandler;
import io.netty.example.udt.util.UtilThreadFactory;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class ByteEchoServer {
    private static final Logger log = Logger.getLogger(ByteEchoServer.class.getName());
    private final int port;

    public ByteEchoServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        UtilThreadFactory acceptFactory = new UtilThreadFactory("accept");
        UtilThreadFactory connectFactory = new UtilThreadFactory("connect");
        NioEventLoopGroup acceptGroup = new NioEventLoopGroup(1, (ThreadFactory)acceptFactory, NioUdtProvider.BYTE_PROVIDER);
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.BYTE_PROVIDER);
        try {
            ServerBootstrap boot = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boot.group((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup).channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, (Object)10)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ByteEchoServerHandler()});
                }
            });
            ChannelFuture future = boot.bind(this.port).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            acceptGroup.shutdownGracefully();
            connectGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("init");
        int port = 1234;
        new ByteEchoServer(1234).run();
        log.info("done");
    }
}

