/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MessageList;
import io.netty.example.proxy.HexDumpProxyBackendHandler;
import io.netty.util.concurrent.GenericFutureListener;

public class HexDumpProxyFrontendHandler
extends ChannelInboundHandlerAdapter {
    private final String remoteHost;
    private final int remotePort;
    private volatile Channel outboundChannel;

    public HexDumpProxyFrontendHandler(String remoteHost, int remotePort) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler((ChannelHandler)new HexDumpProxyBackendHandler(inboundChannel))).option(ChannelOption.AUTO_READ, (Object)false);
        ChannelFuture f = b.connect(this.remoteHost, this.remotePort);
        this.outboundChannel = f.channel();
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    inboundChannel.read();
                } else {
                    inboundChannel.close();
                }
            }
        });
    }

    public void messageReceived(final ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        if (this.outboundChannel.isActive()) {
            this.outboundChannel.write(msgs).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        future.channel().close();
                    }
                }
            });
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.outboundChannel != null) {
            HexDumpProxyFrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.write((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

