/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MessageList;
import io.netty.example.uptime.UptimeClient;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class UptimeClientHandler
extends ChannelInboundHandlerAdapter {
    private final UptimeClient client;
    private long startTime = -1L;

    public UptimeClientHandler(UptimeClient client) {
        this.client = client;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.println("Connected to: " + ctx.channel().remoteAddress());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        msgs.releaseAllAndRecycle();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt instanceof IdleStateEvent)) {
            return;
        }
        IdleStateEvent e = (IdleStateEvent)evt;
        if (e.state() == IdleState.READER_IDLE) {
            this.println("Disconnecting due to no inbound traffic");
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.println("Disconnected from: " + ctx.channel().remoteAddress());
    }

    public void channelUnregistered(final ChannelHandlerContext ctx) throws Exception {
        this.println("Sleeping for: 5s");
        final EventLoop loop = ctx.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                UptimeClientHandler.this.println("Reconnecting to: " + ctx.channel().remoteAddress());
                UptimeClientHandler.this.client.configureBootstrap(new Bootstrap(), (EventLoopGroup)loop).connect();
            }
        }, 5L, TimeUnit.SECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ConnectException) {
            this.startTime = -1L;
            this.println("Failed to connect: " + cause.getMessage());
        }
        cause.printStackTrace();
        ctx.close();
    }

    void println(String msg) {
        if (this.startTime < 0L) {
            System.err.format("[SERVER IS DOWN] %s%n", msg);
        } else {
            System.err.format("[UPTIME: %5ds] %s%n", (System.currentTimeMillis() - this.startTime) / 1000L, msg);
        }
    }
}

