/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvous;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MsgEchoPeerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = Logger.getLogger(MsgEchoPeerHandler.class.getName());
    private final UdtMessage message;
    final Meter meter = Metrics.newMeter(MsgEchoPeerHandler.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);

    public MsgEchoPeerHandler(int messageSize) {
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> messages) throws Exception {
        MessageList msgs = messages.cast();
        for (int i = 0; i < msgs.size(); ++i) {
            UdtMessage message = (UdtMessage)msgs.get(i);
            this.meter.mark((long)message.content().readableBytes());
        }
        ctx.write(msgs);
    }
}

