/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.socksproxy.SocksServerConnectHandler;
import io.netty.example.socksproxy.SocksServerUtils;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;

@ChannelHandler.Sharable
public final class SocksServerHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private static final String name = "SOCKS_SERVER_HANDLER";

    public static String getName() {
        return name;
    }

    public void messageReceived(ChannelHandlerContext ctx, SocksRequest socksRequest) throws Exception {
        switch (socksRequest.requestType()) {
            case INIT: {
                ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(SocksCmdRequestDecoder.getName(), (ChannelHandler)new SocksCmdRequestDecoder());
                ctx.write((Object)new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.cmdType() == SocksCmdType.CONNECT) {
                    ctx.pipeline().addLast(SocksServerConnectHandler.getName(), (ChannelHandler)new SocksServerConnectHandler());
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireMessageReceived((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) throws Exception {
        throwable.printStackTrace();
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

