/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.example.socksproxy.SocksServerUtils;

public final class RelayHandler
extends ChannelInboundHandlerAdapter {
    private static final String name = "RELAY_HANDLER";
    private final Channel relayChannel;

    public static String getName() {
        return name;
    }

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        if (this.relayChannel.isActive()) {
            this.relayChannel.write(msgs);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.relayChannel.isActive()) {
            SocksServerUtils.closeOnFlush(this.relayChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

