/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.qotm;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Random;

public class QuoteOfTheMomentServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Random random = new Random();
    private static final String[] quotes = new String[]{"Where there is love there is life.", "First they ignore you, then they laugh at you, then they fight you, then you win.", "Be the change you want to see in the world.", "The weak can never forgive. Forgiveness is the attribute of the strong."};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String nextQuote() {
        int quoteId;
        Random random = QuoteOfTheMomentServerHandler.random;
        synchronized (random) {
            quoteId = QuoteOfTheMomentServerHandler.random.nextInt(quotes.length);
        }
        return quotes[quoteId];
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList packets = msgs.cast();
        for (int i = 0; i < packets.size(); ++i) {
            DatagramPacket packet = (DatagramPacket)packets.get(i);
            System.err.println(packet);
            if (!"QOTM?".equals(((ByteBuf)packet.content()).toString(CharsetUtil.UTF_8))) continue;
            ctx.write((Object)new DatagramPacket(Unpooled.copiedBuffer((CharSequence)("QOTM: " + QuoteOfTheMomentServerHandler.nextQuote()), (Charset)CharsetUtil.UTF_8), (InetSocketAddress)packet.sender()));
        }
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
    }
}

