/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.logging.Logger;

public class HttpUploadClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(HttpUploadClientHandler.class.getName());
    private boolean readingChunks;

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        for (int i = 0; i < msgs.size(); ++i) {
            Object msg = msgs.get(i);
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                logger.info("STATUS: " + response.getStatus());
                logger.info("VERSION: " + response.getProtocolVersion());
                if (!response.headers().isEmpty()) {
                    for (String name : response.headers().names()) {
                        for (String value : response.headers().getAll(name)) {
                            logger.info("HEADER: " + name + " = " + value);
                        }
                    }
                }
                if (response.getStatus().code() == 200 && HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                    this.readingChunks = true;
                    logger.info("CHUNKED CONTENT {");
                } else {
                    logger.info("CONTENT {");
                }
            }
            if (!(msg instanceof HttpContent)) continue;
            HttpContent chunk = (HttpContent)msg;
            logger.info(chunk.content().toString(CharsetUtil.UTF_8));
            if (chunk instanceof LastHttpContent) {
                if (this.readingChunks) {
                    logger.info("} END OF CHUNKED CONTENT");
                } else {
                    logger.info("} END OF CONTENT");
                }
                this.readingChunks = false;
                continue;
            }
            logger.info(chunk.content().toString(CharsetUtil.UTF_8));
        }
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.channel().close();
    }
}

