/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.filetransfer;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MessageList;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;

public class FileServer {
    private final int port;

    public FileServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8), new LineBasedFrameDecoder(8192), new StringDecoder(CharsetUtil.UTF_8), new FileHandler()});
                }
            });
            ChannelFuture f = b.bind(this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new FileServer(port).run();
    }

    private static final class FileHandler
    extends ChannelInboundHandlerAdapter {
        private FileHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> messages) throws Exception {
            MessageList msgs = messages.cast();
            MessageList out = MessageList.newInstance();
            for (int i = 0; i < msgs.size(); ++i) {
                String msg = (String)msgs.get(i);
                File file = new File(msg);
                if (file.exists()) {
                    if (!file.isFile()) {
                        ctx.write((Object)("Not a file: " + file + '\n'));
                        return;
                    }
                    ctx.write((Object)(file + " " + file.length() + '\n'));
                    DefaultFileRegion region = new DefaultFileRegion(new FileInputStream(file).getChannel(), 0L, file.length());
                    out.add((Object)region);
                    out.add((Object)"\n");
                    continue;
                }
                out.add((Object)("File not found: " + file + '\n'));
            }
            msgs.recycle();
            ctx.write(out);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
            ctx.close();
        }
    }
}

