/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvousBytes;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteEchoPeerHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger log = Logger.getLogger(ByteEchoPeerHandler.class.getName());
    private final ByteBuf message;
    final Meter meter = Metrics.newMeter(ByteEchoPeerHandler.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);

    public ByteEchoPeerHandler(int messageSize) {
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ChannelHandlerUtil.allocate((ChannelHandlerContext)ctx, (int)((Integer)ctx.channel().config().getOption(ChannelOption.SO_RCVBUF)));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    protected void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        this.meter.mark((long)in.readableBytes());
        ByteBuf out = ctx.nextOutboundByteBuffer();
        out.writeBytes(in);
        ctx.flush();
    }
}

