/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.example.proxy.HexDumpProxyFrontendHandler;
import io.netty.util.concurrent.GenericFutureListener;

public class HexDumpProxyBackendHandler
extends ChannelInboundByteHandlerAdapter {
    private final Channel inboundChannel;

    public HexDumpProxyBackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        ctx.flush();
    }

    public void inboundBufferUpdated(final ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf out = this.inboundChannel.outboundByteBuffer();
        out.writeBytes(in);
        this.inboundChannel.flush().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HexDumpProxyFrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }
}

