/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.math.BigInteger;

public class BigIntegerDecoder
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, MessageBuf<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        in.markReaderIndex();
        short magicNumber = in.readUnsignedByte();
        if (magicNumber != 70) {
            in.resetReaderIndex();
            throw new CorruptedFrameException("Invalid magic number: " + magicNumber);
        }
        int dataLength = in.readInt();
        if (in.readableBytes() < dataLength) {
            in.resetReaderIndex();
            return;
        }
        byte[] decoded = new byte[dataLength];
        in.readBytes(decoded);
        out.add((Object)new BigInteger(decoded));
    }
}

