/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscardClientHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger logger = Logger.getLogger(DiscardClientHandler.class.getName());
    private final int messageSize;
    private ByteBuf content;
    private ChannelHandlerContext ctx;
    long counter;
    private final ChannelFutureListener trafficGenerator = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                DiscardClientHandler.this.generateTraffic();
            }
        }
    };

    public DiscardClientHandler(int messageSize) {
        if (messageSize <= 0) {
            throw new IllegalArgumentException("messageSize: " + messageSize);
        }
        this.messageSize = messageSize;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.content = ctx.alloc().directBuffer(this.messageSize).writeZero(this.messageSize);
        this.generateTraffic();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        in.clear();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private void generateTraffic() {
        ByteBuf out = this.ctx.nextOutboundByteBuffer();
        while (out.readableBytes() < 65536) {
            out.writeBytes(this.content, 0, this.content.readableBytes());
        }
        this.ctx.flush().addListener((GenericFutureListener)this.trafficGenerator);
    }
}

