/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.portunification;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.example.factorial.BigIntegerDecoder;
import io.netty.example.factorial.FactorialServerHandler;
import io.netty.example.factorial.NumberEncoder;
import io.netty.example.http.snoop.HttpSnoopServerHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class PortUnificationServerHandler
extends ChannelInboundByteHandlerAdapter {
    private final boolean detectSsl;
    private final boolean detectGzip;

    public PortUnificationServerHandler() {
        this(true, true);
    }

    private PortUnificationServerHandler(boolean detectSsl, boolean detectGzip) {
        this.detectSsl = detectSsl;
        this.detectGzip = detectGzip;
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(in)) {
            this.enableSsl(ctx);
        } else {
            short magic2;
            short magic1 = in.getUnsignedByte(in.readerIndex());
            if (this.isGzip(magic1, magic2 = in.getUnsignedByte(in.readerIndex() + 1))) {
                this.enableGzip(ctx);
            } else if (PortUnificationServerHandler.isHttp(magic1, magic2)) {
                this.switchToHttp(ctx);
            } else if (PortUnificationServerHandler.isFactorial(magic1)) {
                this.switchToFactorial(ctx);
            } else {
                in.clear();
                ctx.close();
            }
        }
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }

    private boolean isGzip(int magic1, int magic2) {
        if (this.detectGzip) {
            return magic1 == 31 && magic2 == 139;
        }
        return false;
    }

    private static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private static boolean isFactorial(int magic1) {
        return magic1 == 70;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        SSLEngine engine = SecureChatSslContextFactory.getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        p.addLast("unificationA", (ChannelHandler)new PortUnificationServerHandler(false, this.detectGzip));
        p.remove((ChannelHandler)this);
    }

    private void enableGzip(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("gzipdeflater", (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP));
        p.addLast("gzipinflater", (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP));
        p.addLast("unificationB", (ChannelHandler)new PortUnificationServerHandler(this.detectSsl, false));
        p.remove((ChannelHandler)this);
    }

    private void switchToHttp(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        p.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        p.addLast("handler", (ChannelHandler)new HttpSnoopServerHandler());
        p.remove((ChannelHandler)this);
    }

    private void switchToFactorial(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("decoder", (ChannelHandler)new BigIntegerDecoder());
        p.addLast("encoder", (ChannelHandler)new NumberEncoder());
        p.addLast("handler", (ChannelHandler)new FactorialServerHandler());
        p.remove((ChannelHandler)this);
    }
}

