/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.message;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.message.MsgEchoServerHandler;
import io.netty.example.udt.util.UtilThreadFactory;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class MsgEchoServer {
    private static final Logger log = Logger.getLogger(MsgEchoServer.class.getName());
    private final int port;

    public MsgEchoServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        UtilThreadFactory acceptFactory = new UtilThreadFactory("accept");
        UtilThreadFactory connectFactory = new UtilThreadFactory("connect");
        NioEventLoopGroup acceptGroup = new NioEventLoopGroup(1, (ThreadFactory)acceptFactory, NioUdtProvider.MESSAGE_PROVIDER);
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.MESSAGE_PROVIDER);
        ServerBootstrap boot = new ServerBootstrap();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boot.group((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup).channelFactory(NioUdtProvider.MESSAGE_ACCEPTOR)).option(ChannelOption.SO_BACKLOG, (Object)10)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new MsgEchoServerHandler()});
                }
            });
            ChannelFuture future = boot.bind(this.port).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            boot.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("init");
        int port = 1234;
        new MsgEchoServer(1234).run();
        log.info("done");
    }
}

