/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.example.socksproxy.SocksServerUtils;

public final class RelayHandler
extends ChannelInboundByteHandlerAdapter {
    private static final String name = "RELAY_HANDLER";
    private final Channel relayChannel;

    public static String getName() {
        return name;
    }

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf out = this.relayChannel.outboundByteBuffer();
        out.writeBytes(in);
        if (this.relayChannel.isActive()) {
            this.relayChannel.flush();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.relayChannel.isActive()) {
            SocksServerUtils.closeOnFlush(this.relayChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

