/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.message;

import io.netty.buffer.MessageBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

@ChannelHandler.Sharable
public class MsgEchoServerHandler
extends ChannelInboundMessageHandlerAdapter<UdtMessage> {
    private static final Logger log = Logger.getLogger(MsgEchoServerHandler.class.getName());

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
    }

    public void messageReceived(ChannelHandlerContext ctx, UdtMessage message) throws Exception {
        MessageBuf out = ctx.nextOutboundMessageBuffer();
        out.add((Object)message);
        ctx.flush();
    }
}

