/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.message;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.udt.UdtMessage;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MsgEchoClientHandler
extends ChannelInboundMessageHandlerAdapter<UdtMessage> {
    private static final Logger log = Logger.getLogger(MsgEchoClientHandler.class.getName());
    private final UdtMessage message;
    final Meter meter = Metrics.newMeter(MsgEchoClientHandler.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);

    public MsgEchoClientHandler(int messageSize) {
        ByteBuf byteBuf = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < byteBuf.capacity(); ++i) {
            byteBuf.writeByte((int)((byte)i));
        }
        this.message = new UdtMessage(byteBuf);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        MessageBuf out = ctx.nextOutboundMessageBuffer();
        out.add((Object)this.message);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void messageReceived(ChannelHandlerContext ctx, UdtMessage message) throws Exception {
        ByteBuf byteBuf = message.data();
        this.meter.mark((long)byteBuf.readableBytes());
        MessageBuf out = ctx.nextOutboundMessageBuffer();
        out.add((Object)message);
        ctx.flush();
    }
}

