/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.applet;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.CharsetUtil;
import javax.swing.JApplet;

public class AppletDiscardServer
extends JApplet {
    private static final long serialVersionUID = -7824894101960583175L;
    private ServerBootstrap bootstrap;

    @Override
    public void init() {
        try {
            this.bootstrap = new ServerBootstrap();
            ((ServerBootstrap)this.bootstrap.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new DiscardServerHandler()});
                }
            });
            ChannelFuture f = this.bootstrap.bind(9999).sync();
            f.channel().closeFuture().sync();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.bootstrap != null) {
            this.bootstrap.shutdown();
        }
    }

    private static final class DiscardServerHandler
    extends ChannelInboundByteHandlerAdapter {
        private DiscardServerHandler() {
        }

        public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            System.out.println("Received: " + in.toString(CharsetUtil.UTF_8));
            in.clear();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
            ctx.close();
        }
    }
}

