/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.bytes.ByteEchoClientHandler;
import io.netty.example.udt.util.UtilConsoleReporter;
import io.netty.example.udt.util.UtilThreadFactory;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ByteEchoClient {
    private static final Logger log = Logger.getLogger(ByteEchoClient.class.getName());
    private final String host;
    private final int port;
    private final int messageSize;

    public ByteEchoClient(String host, int port, int messageSize) {
        this.host = host;
        this.port = port;
        this.messageSize = messageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap boot = new Bootstrap();
        UtilThreadFactory connectFactory = new UtilThreadFactory("connect");
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.BYTE_PROVIDER);
        try {
            ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.BYTE_CONNECTOR)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ByteEchoClientHandler(ByteEchoClient.this.messageSize)});
                }
            });
            ChannelFuture f = boot.connect(this.host, this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            boot.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("init");
        UtilConsoleReporter.enable(3L, TimeUnit.SECONDS);
        String host = "localhost";
        int port = 1234;
        int messageSize = 65536;
        new ByteEchoClient("localhost", 1234, 65536).run();
        log.info("done");
    }
}

