/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.proxy.HexDumpProxyInitializer;

public class HexDumpProxy {
    private final int localPort;
    private final String remoteHost;
    private final int remotePort;

    public HexDumpProxy(int localPort, String remoteHost, int remotePort) {
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void run() throws Exception {
        System.err.println("Proxying *:" + this.localPort + " to " + this.remoteHost + ':' + this.remotePort + " ...");
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)b.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HexDumpProxyInitializer(this.remoteHost, this.remotePort));
            b.bind(this.localPort).sync().channel().closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: " + HexDumpProxy.class.getSimpleName() + " <local port> <remote host> <remote port>");
            return;
        }
        int localPort = Integer.parseInt(args[0]);
        String remoteHost = args[1];
        int remotePort = Integer.parseInt(args[2]);
        new HexDumpProxy(localPort, remoteHost, remotePort).run();
    }
}

