/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.objectecho;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectEchoClientHandler
extends ChannelInboundMessageHandlerAdapter<List<Integer>> {
    private static final Logger logger = Logger.getLogger(ObjectEchoClientHandler.class.getName());
    private final List<Integer> firstMessage;

    public ObjectEchoClientHandler(int firstMessageSize) {
        super(new Class[0]);
        if (firstMessageSize <= 0) {
            throw new IllegalArgumentException("firstMessageSize: " + firstMessageSize);
        }
        this.firstMessage = new ArrayList<Integer>(firstMessageSize);
        for (int i = 0; i < firstMessageSize; ++i) {
            this.firstMessage.add(i);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.write(this.firstMessage);
    }

    public void messageReceived(ChannelHandlerContext ctx, List<Integer> msg) throws Exception {
        ctx.write(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

