/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.upload.HttpUploadClientIntializer;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public class HttpUploadClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpUploadClient.class);
    private final String baseUri;
    private final String filePath;
    private static final String textArea = "short text";

    public HttpUploadClient(String baseUri, String filePath) {
        this.baseUri = baseUri;
        this.filePath = filePath;
    }

    public void run() throws Exception {
        URI uriFile;
        URI uriSimple;
        String get;
        String postFile;
        String postSimple;
        if (this.baseUri.endsWith("/")) {
            postSimple = this.baseUri + "formpost";
            postFile = this.baseUri + "formpostmultipart";
            get = this.baseUri + "formget";
        } else {
            postSimple = this.baseUri + "/formpost";
            postFile = this.baseUri + "/formpostmultipart";
            get = this.baseUri + "/formget";
        }
        try {
            uriSimple = new URI(postSimple);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI syntax" + e.getCause());
            return;
        }
        String scheme = uriSimple.getScheme() == null ? "http" : uriSimple.getScheme();
        String host = uriSimple.getHost() == null ? "localhost" : uriSimple.getHost();
        int port = uriSimple.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            logger.error("Only HTTP(S) is supported.");
            return;
        }
        boolean ssl = "https".equalsIgnoreCase(scheme);
        try {
            uriFile = new URI(postFile);
        }
        catch (URISyntaxException e) {
            logger.error("Error: " + e.getMessage());
            return;
        }
        File file = new File(this.filePath);
        if (!file.canRead()) {
            logger.error("A correct path is needed");
            return;
        }
        Bootstrap b = new Bootstrap();
        ((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class).handler((ChannelHandler)new HttpUploadClientIntializer(ssl));
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
        List<Map.Entry<String, String>> headers = HttpUploadClient.formGet(b, host, port, get, uriSimple);
        if (headers == null) {
            factory.cleanAllHttpDatas();
            return;
        }
        List<InterfaceHttpData> bodylist = HttpUploadClient.formPost(b, host, port, uriSimple, file, (HttpDataFactory)factory, headers);
        if (bodylist == null) {
            factory.cleanAllHttpDatas();
            return;
        }
        HttpUploadClient.formPostMultipart(b, host, port, uriFile, (HttpDataFactory)factory, headers, bodylist);
        b.shutdown();
        factory.cleanAllHttpDatas();
    }

    private static List<Map.Entry<String, String>> formGet(Bootstrap bootstrap, String host, int port, String get, URI uriSimple) throws Exception {
        URI uriGet;
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(host, port));
        Channel channel = bootstrap.connect().sync().channel();
        QueryStringEncoder encoder = new QueryStringEncoder(get);
        encoder.addParam("getform", "GET");
        encoder.addParam("info", "first value");
        encoder.addParam("secondinfo", "secondvalue \ufffd\ufffd\ufffd&");
        encoder.addParam("thirdinfo", "third value\r\ntest second line\r\n\r\nnew line\r\n");
        encoder.addParam("Send", "Send");
        try {
            uriGet = new URI(encoder.toString());
        }
        catch (URISyntaxException e) {
            logger.error("Error: " + e.getMessage());
            return null;
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uriGet.toASCIIString());
        request.setHeader("Host", (Object)host);
        request.setHeader("Connection", (Object)"close");
        request.setHeader("Accept-Encoding", (Object)"gzip,deflate");
        request.setHeader("Accept-Charset", (Object)"ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        request.setHeader("Accept-Language", (Object)"fr");
        request.setHeader("Referer", (Object)uriSimple.toString());
        request.setHeader("User-Agent", (Object)"Netty Simple Http Client side");
        request.setHeader("Accept", (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Cookie", (Object)ClientCookieEncoder.encode((Cookie[])new Cookie[]{new DefaultCookie("my-cookie", "foo"), new DefaultCookie("another-cookie", "bar")}));
        List headers = request.getHeaders();
        channel.write((Object)request);
        channel.closeFuture().sync();
        return headers;
    }

    private static List<InterfaceHttpData> formPost(Bootstrap bootstrap, String host, int port, URI uriSimple, File file, HttpDataFactory factory, List<Map.Entry<String, String>> headers) throws Exception {
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(host, port));
        Channel channel = bootstrap.connect().sync().channel();
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uriSimple.toASCIIString());
        HttpPostRequestEncoder bodyRequestEncoder = null;
        try {
            bodyRequestEncoder = new HttpPostRequestEncoder(factory, (HttpRequest)request, false);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, String> entry : headers) {
            request.setHeader(entry.getKey(), (Object)entry.getValue());
        }
        try {
            bodyRequestEncoder.addBodyAttribute("getform", "POST");
            bodyRequestEncoder.addBodyAttribute("info", "first value");
            bodyRequestEncoder.addBodyAttribute("secondinfo", "secondvalue \ufffd\ufffd\ufffd&");
            bodyRequestEncoder.addBodyAttribute("thirdinfo", textArea);
            bodyRequestEncoder.addBodyFileUpload("myfile", file, "application/x-zip-compressed", false);
            bodyRequestEncoder.addBodyAttribute("Send", "Send");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            e.printStackTrace();
        }
        try {
            request = bodyRequestEncoder.finalizeRequest();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            e.printStackTrace();
        }
        List bodylist = bodyRequestEncoder.getBodyListAttributes();
        channel.write((Object)request);
        if (bodyRequestEncoder.isChunked()) {
            channel.write((Object)bodyRequestEncoder).awaitUninterruptibly();
        }
        channel.closeFuture().sync();
        return bodylist;
    }

    private static void formPostMultipart(Bootstrap bootstrap, String host, int port, URI uriFile, HttpDataFactory factory, List<Map.Entry<String, String>> headers, List<InterfaceHttpData> bodylist) throws Exception {
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(host, port));
        Channel channel = bootstrap.connect().sync().channel();
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uriFile.toASCIIString());
        HttpPostRequestEncoder bodyRequestEncoder = null;
        try {
            bodyRequestEncoder = new HttpPostRequestEncoder(factory, (HttpRequest)request, true);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, String> entry : headers) {
            request.setHeader(entry.getKey(), (Object)entry.getValue());
        }
        try {
            bodyRequestEncoder.setBodyHttpDatas(bodylist);
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e1) {
            e1.printStackTrace();
        }
        try {
            bodyRequestEncoder.finalizeRequest();
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            e.printStackTrace();
        }
        channel.write((Object)request);
        if (bodyRequestEncoder.isChunked()) {
            channel.write((Object)bodyRequestEncoder).awaitUninterruptibly();
        }
        bodyRequestEncoder.cleanFiles();
        channel.closeFuture().sync();
    }

    public static void main(String[] args) throws Exception {
        String filePath;
        String baseUri;
        if (args.length == 2) {
            baseUri = args[0];
            filePath = args[1];
        } else {
            baseUri = "http://localhost:8080";
            File f = File.createTempFile("upload", ".txt");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("Some text data in a file to be posted");
            bw.close();
            filePath = f.getPath();
            f.deleteOnExit();
        }
        logger.info("Posting to " + baseUri + ". Using file " + filePath);
        new HttpUploadClient(baseUri, filePath).run();
    }
}

