/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.snoop.HttpSnoopClientHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class HttpSnoopClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final boolean ssl;

    public HttpSnoopClientInitializer(boolean ssl) {
        this.ssl = ssl;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        p.addLast("log", (ChannelHandler)new LoggingHandler(LogLevel.INFO));
        if (this.ssl) {
            SSLEngine engine = SecureChatSslContextFactory.getClientContext().createSSLEngine();
            engine.setUseClientMode(true);
            p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        p.addLast("codec", (ChannelHandler)new HttpClientCodec());
        p.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        p.addLast("handler", (ChannelHandler)new HttpSnoopClientHandler());
    }
}

