/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.autobahn;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.http.websocketx.autobahn.AutobahnServerInitializer;

public class AutobahnServer {
    private final int port;

    public AutobahnServer(int port) {
        this.port = port;
    }

    public void run() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)b.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class).localAddress(this.port)).childHandler((ChannelHandler)new AutobahnServerInitializer());
            ChannelFuture f = b.bind().sync();
            System.out.println("Web Socket Server started at port " + this.port);
            f.channel().closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 9000;
        new AutobahnServer(port).run();
    }
}

