/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import java.math.BigInteger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactorialClientHandler
extends ChannelInboundMessageHandlerAdapter<BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorialClientHandler.class.getName());
    private ChannelHandlerContext ctx;
    private int i = 1;
    private int receivedMessages;
    private final int count;
    final BlockingQueue<BigInteger> answer = new LinkedBlockingQueue<BigInteger>();
    private final ChannelFutureListener SEND_NUMBERS = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                FactorialClientHandler.this.sendNumbers();
            }
        }
    };

    public FactorialClientHandler(int count) {
        super(new Class[0]);
        this.count = count;
    }

    public BigInteger getFactorial() {
        boolean interrupted = false;
        while (true) {
            try {
                BigInteger factorial = this.answer.take();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return factorial;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.sendNumbers();
    }

    public void messageReceived(ChannelHandlerContext ctx, final BigInteger msg) {
        ++this.receivedMessages;
        if (this.receivedMessages == this.count) {
            ctx.channel().close().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    boolean offered = FactorialClientHandler.this.answer.offer(msg);
                    assert (offered);
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private void sendNumbers() {
        boolean finished = false;
        MessageBuf out = this.ctx.nextOutboundMessageBuffer();
        while (out.size() < 4096) {
            if (this.i <= this.count) {
                out.add((Object)this.i);
                ++this.i;
                continue;
            }
            finished = true;
            break;
        }
        ChannelFuture f = this.ctx.flush();
        if (!finished) {
            f.addListener(this.SEND_NUMBERS);
        }
    }
}

