/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.discard.DiscardClientHandler;

public class DiscardClient {
    private final String host;
    private final int port;
    private final int firstMessageSize;

    public DiscardClient(String host, int port, int firstMessageSize) {
        this.host = host;
        this.port = port;
        this.firstMessageSize = firstMessageSize;
    }

    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).remoteAddress(this.host, this.port).handler((ChannelHandler)new DiscardClientHandler(this.firstMessageSize));
            ChannelFuture f = b.connect().sync();
            f.channel().closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: " + DiscardClient.class.getSimpleName() + " <host> <port> [<first message size>]");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int firstMessageSize = args.length == 3 ? Integer.parseInt(args[2]) : 256;
        new DiscardClient(host, port, firstMessageSize).run();
    }
}

