/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.ssl.SslHandler;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecureChatServerHandler
extends ChannelInboundMessageHandlerAdapter<String> {
    private static final Logger logger = Logger.getLogger(SecureChatServerHandler.class.getName());
    static final ChannelGroup channels = new DefaultChannelGroup();

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.write((Object)("Welcome to " + InetAddress.getLocalHost().getHostName() + " secure chat service!\n"));
        ctx.write((Object)("Your session is protected by " + ((SslHandler)ctx.pipeline().get(SslHandler.class)).getEngine().getSession().getCipherSuite() + " cipher suite.\n"));
        channels.add((Object)ctx.channel());
    }

    public void messageReceived(ChannelHandlerContext ctx, String request) throws Exception {
        for (Channel c : channels) {
            if (c != ctx.channel()) {
                c.write((Object)("[" + ctx.channel().remoteAddress() + "] " + request + '\n'));
                continue;
            }
            c.write((Object)("[you] " + request + '\n'));
        }
        if (request.toLowerCase().equals("bye")) {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

