/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.localtime;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.example.localtime.LocalTimeProtocol;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTimeServerHandler
extends ChannelInboundMessageHandlerAdapter<LocalTimeProtocol.Locations> {
    private static final Logger logger = Logger.getLogger(LocalTimeServerHandler.class.getName());

    public void messageReceived(ChannelHandlerContext ctx, LocalTimeProtocol.Locations locations) throws Exception {
        long currentTime = System.currentTimeMillis();
        LocalTimeProtocol.LocalTimes.Builder builder = LocalTimeProtocol.LocalTimes.newBuilder();
        for (LocalTimeProtocol.Location l : locations.getLocationList()) {
            TimeZone tz = TimeZone.getTimeZone(LocalTimeServerHandler.toString(l.getContinent()) + '/' + l.getCity());
            Calendar calendar = Calendar.getInstance(tz);
            calendar.setTimeInMillis(currentTime);
            builder.addLocalTime(LocalTimeProtocol.LocalTime.newBuilder().setYear(calendar.get(1)).setMonth(calendar.get(2) + 1).setDayOfMonth(calendar.get(5)).setDayOfWeek(LocalTimeProtocol.DayOfWeek.valueOf(calendar.get(7))).setHour(calendar.get(11)).setMinute(calendar.get(12)).setSecond(calendar.get(13)).build());
        }
        ctx.write((Object)builder.build());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private static String toString(LocalTimeProtocol.Continent c) {
        return c.name().charAt(0) + c.name().toLowerCase().substring(1);
    }
}

