/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.file;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;

public class HttpStaticFileServerHandler
extends ChannelInboundMessageHandlerAdapter<HttpRequest> {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;

    public void messageReceived(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        RandomAccessFile raf;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        if (!request.getDecoderResult().isSuccess()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (request.getMethod() != HttpMethod.GET) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = request.getUri();
        String path = HttpStaticFileServerHandler.sanitizeUri(uri);
        if (path == null) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (file.isDirectory()) {
            if (uri.endsWith("/")) {
                HttpStaticFileServerHandler.sendListing(ctx, file);
            } else {
                HttpStaticFileServerHandler.sendRedirect(ctx, uri + '/');
            }
            return;
        }
        if (!file.isFile()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.equals("") && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            HttpStaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fnfe) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        HttpStaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
        HttpStaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            response.setHeader("Connection", (Object)"keep-alive");
        }
        ctx.write((Object)response);
        ChannelFuture writeFuture = ctx.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        if (!uri.startsWith("/")) {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        return System.getProperty("user.dir") + File.separator + uri;
    }

    private static void sendListing(ChannelHandlerContext ctx, File dir) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Type", (Object)"text/html; charset=UTF-8");
        StringBuilder buf = new StringBuilder();
        buf.append("<!DOCTYPE html>\r\n");
        buf.append("<html><head><title>");
        buf.append("Listing of: ");
        buf.append(dir.getPath());
        buf.append("</title></head><body>\r\n");
        buf.append("<h3>Listing of: ");
        buf.append(dir.getPath());
        buf.append("</h3>\r\n");
        buf.append("<ul>");
        buf.append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : dir.listFiles()) {
            if (f.isHidden() || !f.canRead()) continue;
            String name = f.getName();
            buf.append("<li><a href=\"");
            buf.append(name);
            buf.append("\">");
            buf.append(name);
            buf.append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        response.setContent(Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8));
        ctx.write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.setHeader("Location", (Object)newUri);
        ctx.write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        HttpStaticFileServerHandler.setDateHeader((HttpResponse)response);
        ctx.write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.setHeader("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.setHeader("Expires", (Object)dateFormatter.format(time.getTime()));
        response.setHeader("Cache-Control", (Object)"private, max-age=60");
        response.setHeader("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.setHeader("Content-Type", (Object)mimeTypesMap.getContentType(file.getPath()));
    }
}

