/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.factorial.FactorialClientHandler;
import io.netty.example.factorial.FactorialClientInitializer;

public class FactorialClient {
    private final String host;
    private final int port;
    private final int count;

    public FactorialClient(String host, int port, int count) {
        this.host = host;
        this.port = port;
        this.count = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).remoteAddress(this.host, this.port).handler((ChannelHandler)new FactorialClientInitializer(this.count));
            ChannelFuture f = b.connect().sync();
            FactorialClientHandler handler = (FactorialClientHandler)f.channel().pipeline().last();
            System.err.format("Factorial of %,d is: %,d", this.count, handler.getFactorial());
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: " + FactorialClient.class.getSimpleName() + " <host> <port> <count>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int count = Integer.parseInt(args[2]);
        if (count <= 0) {
            throw new IllegalArgumentException("count must be a positive integer.");
        }
        new FactorialClient(host, port, count).run();
    }
}

