/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscardClientHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger logger = Logger.getLogger(DiscardClientHandler.class.getName());
    private final byte[] content;
    private ChannelHandlerContext ctx;
    long counter;
    private final ChannelFutureListener GENERATE_TRAFFIC = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                DiscardClientHandler.this.ctx.nextOutboundByteBuffer().discardReadBytes();
                DiscardClientHandler.this.generateTraffic();
            }
        }
    };

    public DiscardClientHandler(int messageSize) {
        if (messageSize <= 0) {
            throw new IllegalArgumentException("messageSize: " + messageSize);
        }
        this.content = new byte[messageSize];
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.generateTraffic();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        in.clear();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private void generateTraffic() {
        ByteBuf out = this.ctx.nextOutboundByteBuffer();
        while (out.readableBytes() < 65536) {
            out.writeBytes(this.content);
        }
        this.ctx.flush().addListener(this.GENERATE_TRAFFIC);
    }
}

