/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.example.proxy.HexDumpProxyFrontendHandler;

public class HexDumpProxyBackendHandler
extends ChannelInboundByteHandlerAdapter {
    private final Channel inboundChannel;

    public HexDumpProxyBackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf out = this.inboundChannel.outboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        in.clear();
        this.inboundChannel.flush();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HexDumpProxyFrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }
}

