/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioEventLoop;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.websocketx.client.WebSocketClientHandler;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.HashMap;

public class WebSocketClient {
    private final URI uri;

    public WebSocketClient(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            String protocol = this.uri.getScheme();
            if (!protocol.equals("ws")) {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("MyHeader", "MyValue");
            final WebSocketClientHandshaker handshaker = new WebSocketClientHandshakerFactory().newHandshaker(this.uri, WebSocketVersion.V13, null, false, customHeaders);
            b.eventLoop((EventLoop)new NioEventLoop()).channel((Channel)new NioSocketChannel()).remoteAddress(this.uri.getHost(), this.uri.getPort()).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                    pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                    pipeline.addLast("ws-handler", (ChannelHandler)new WebSocketClientHandler(handshaker));
                }
            });
            System.out.println("WebSocket Client connecting");
            Channel ch = b.connect().sync().channel();
            handshaker.handshake(ch).sync();
            System.out.println("WebSocket Client sending message");
            for (int i = 0; i < 1000; ++i) {
                ch.write((Object)new TextWebSocketFrame("Message #" + i));
            }
            System.out.println("WebSocket Client sending ping");
            ch.write((Object)new PingWebSocketFrame(Unpooled.copiedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6})));
            System.out.println("WebSocket Client sending close");
            ch.write((Object)new CloseWebSocketFrame());
            ch.closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        URI uri = args.length > 0 ? new URI(args[0]) : new URI("ws://localhost:8080/websocket");
        new WebSocketClient(uri).run();
    }
}

