/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpSnoopServerHandler
extends ChannelInboundMessageHandlerAdapter<Object> {
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder buf = new StringBuilder();

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.readingChunks) {
            this.request = (HttpRequest)msg;
            HttpRequest request = this.request;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                HttpSnoopServerHandler.send100Continue(ctx);
            }
            this.buf.setLength(0);
            this.buf.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.buf.append("===================================\r\n");
            this.buf.append("VERSION: " + request.getProtocolVersion() + "\r\n");
            this.buf.append("HOSTNAME: " + HttpHeaders.getHost((HttpMessage)request, (String)"unknown") + "\r\n");
            this.buf.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            for (Map.Entry h : request.getHeaders()) {
                this.buf.append("HEADER: " + (String)h.getKey() + " = " + (String)h.getValue() + "\r\n");
            }
            this.buf.append("\r\n");
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
            Map params = queryStringDecoder.getParameters();
            if (!params.isEmpty()) {
                for (Map.Entry p : params.entrySet()) {
                    String key = (String)p.getKey();
                    List vals = (List)p.getValue();
                    for (String val : vals) {
                        this.buf.append("PARAM: " + key + " = " + val + "\r\n");
                    }
                }
                this.buf.append("\r\n");
            }
            if (request.isChunked()) {
                this.readingChunks = true;
            } else {
                ByteBuf content = request.getContent();
                if (content.readable()) {
                    this.buf.append("CONTENT: " + content.toString(CharsetUtil.UTF_8) + "\r\n");
                }
                this.writeResponse(ctx);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.isLast()) {
                this.readingChunks = false;
                this.buf.append("END OF CONTENT\r\n");
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                if (!trailer.getHeaderNames().isEmpty()) {
                    this.buf.append("\r\n");
                    for (String name : trailer.getHeaderNames()) {
                        for (String value : trailer.getHeaders(name)) {
                            this.buf.append("TRAILING HEADER: " + name + " = " + value + "\r\n");
                        }
                    }
                    this.buf.append("\r\n");
                }
                this.writeResponse(ctx);
            } else {
                this.buf.append("CHUNK: " + chunk.getContent().toString(CharsetUtil.UTF_8) + "\r\n");
            }
        }
    }

    private void writeResponse(ChannelHandlerContext ctx) {
        String cookieString;
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)this.request);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(Unpooled.copiedBuffer((CharSequence)this.buf.toString(), (Charset)CharsetUtil.UTF_8));
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (keepAlive) {
            response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
            response.setHeader("Connection", (Object)"keep-alive");
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null) {
            Set cookies = CookieDecoder.decode((String)cookieString);
            if (!cookies.isEmpty()) {
                for (Cookie cookie : cookies) {
                    response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((Cookie)cookie));
                }
            }
        } else {
            response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((String)"key1", (String)"value1"));
            response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((String)"key2", (String)"value2"));
        }
        ChannelFuture future = ctx.write((Object)response);
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

