/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.MathUtil;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    @Test
    public void testFindNextPositivePowerOfTwo() {
        Assert.assertEquals((long)1L, (long)MathUtil.findNextPositivePowerOfTwo((int)0));
        Assert.assertEquals((long)1L, (long)MathUtil.findNextPositivePowerOfTwo((int)1));
        Assert.assertEquals((long)1024L, (long)MathUtil.findNextPositivePowerOfTwo((int)1000));
        Assert.assertEquals((long)1024L, (long)MathUtil.findNextPositivePowerOfTwo((int)1023));
        Assert.assertEquals((long)2048L, (long)MathUtil.findNextPositivePowerOfTwo((int)2048));
        Assert.assertEquals((long)0x40000000L, (long)MathUtil.findNextPositivePowerOfTwo((int)0x3FFFFFFF));
        Assert.assertEquals((long)1L, (long)MathUtil.findNextPositivePowerOfTwo((int)-1));
        Assert.assertEquals((long)1L, (long)MathUtil.findNextPositivePowerOfTwo((int)-10000));
    }

    @Test
    public void testSafeFindNextPositivePowerOfTwo() {
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)0));
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)1));
        Assert.assertEquals((long)1024L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)1000));
        Assert.assertEquals((long)1024L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)1023));
        Assert.assertEquals((long)2048L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)2048));
        Assert.assertEquals((long)0x40000000L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)0x3FFFFFFF));
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)-1));
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)-10000));
        Assert.assertEquals((long)0x40000000L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0x40000000L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)0x40000001));
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)MathUtil.safeFindNextPositivePowerOfTwo((int)-2147483647));
    }

    @Test
    public void testIsOutOfBounds() {
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0, (int)0));
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0, (int)1));
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)1, (int)1));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)1, (int)1, (int)1));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)1, (int)1));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)1));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0, (int)0x7FFFFFFE, (int)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)0, (int)Integer.MAX_VALUE, (int)0x7FFFFFFE));
        Assert.assertFalse((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)1, (int)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)1, (int)0x7FFFFFFE));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)0x7FFFFFFE, (int)2, (int)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)MathUtil.isOutOfBounds((int)1, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((long)-1L, (long)MathUtil.compare((int)0, (int)1));
        Assert.assertEquals((long)-1L, (long)MathUtil.compare((long)0L, (long)1L));
        Assert.assertEquals((long)-1L, (long)MathUtil.compare((int)0, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)MathUtil.compare((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)MathUtil.compare((int)0, (int)0));
        Assert.assertEquals((long)0L, (long)MathUtil.compare((long)0L, (long)0L));
        Assert.assertEquals((long)0L, (long)MathUtil.compare((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)0L, (long)MathUtil.compare((long)Long.MIN_VALUE, (long)Long.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)MathUtil.compare((int)Integer.MAX_VALUE, (int)0));
        Assert.assertEquals((long)1L, (long)MathUtil.compare((int)Integer.MAX_VALUE, (int)0x7FFFFFFE));
        Assert.assertEquals((long)1L, (long)MathUtil.compare((long)Long.MAX_VALUE, (long)0L));
        Assert.assertEquals((long)1L, (long)MathUtil.compare((long)Long.MAX_VALUE, (long)0x7FFFFFFFFFFFFFFEL));
    }
}

