/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import org.junit.Assert;
import org.junit.Test;

public class MacAddressUtilTest {
    @Test
    public void testCompareAddresses() {
        Assert.assertEquals((long)0L, (long)MacAddressUtil.compareAddresses((byte[])EmptyArrays.EMPTY_BYTES, (byte[])new byte[]{82, 84, 0, -7, 50, -67}));
        Assert.assertEquals((long)-1L, (long)MacAddressUtil.compareAddresses((byte[])EmptyArrays.EMPTY_BYTES, (byte[])new byte[]{80, 84, 0, -7, 50, -67}));
        Assert.assertEquals((long)-1L, (long)MacAddressUtil.compareAddresses((byte[])new byte[]{82, 84, 0, -7, 50, -67}, (byte[])new byte[]{80, 84, 0, -7, 50, -67}));
        Assert.assertEquals((long)1L, (long)MacAddressUtil.compareAddresses((byte[])new byte[]{82, 84, 0, -7, 50, -67}, (byte[])EmptyArrays.EMPTY_BYTES));
        Assert.assertEquals((long)1L, (long)MacAddressUtil.compareAddresses((byte[])new byte[]{80, 84, 0, -7, 50, -67}, (byte[])new byte[]{82, 84, 0, -7, 50, -67}));
        Assert.assertEquals((long)0L, (long)MacAddressUtil.compareAddresses((byte[])new byte[]{80, 84, 0, -7, 50, -67}, (byte[])new byte[]{80, 85, 1, -6, 51, -66}));
    }

    @Test
    public void testParseMacEUI48() {
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC"));
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC"));
    }

    @Test
    public void testParseMacMAC48ToEUI64() {
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -1, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-FF-FF-BB-22-CC"));
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -1, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:FF:FF:BB:22:CC"));
    }

    @Test
    public void testParseMacEUI48ToEUI64() {
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -2, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22-CC"));
        Assert.assertArrayEquals((byte[])new byte[]{0, -86, 17, -1, -2, -69, 34, -52}, (byte[])MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22:CC"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalid7HexGroupsA() {
        MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC-FF");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalid7HexGroupsB() {
        MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC:FF");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI48MixedSeparatorA() {
        MacAddressUtil.parseMAC((String)"00-AA:11-BB-22-CC");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI48MixedSeparatorB() {
        MacAddressUtil.parseMAC((String)"00:AA-11:BB:22:CC");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI64MixedSeparatorA() {
        MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22:CC");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI64MixedSeparatorB() {
        MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22-CC");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI48TrailingSeparatorA() {
        MacAddressUtil.parseMAC((String)"00-AA-11-BB-22-CC-");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI48TrailingSeparatorB() {
        MacAddressUtil.parseMAC((String)"00:AA:11:BB:22:CC:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI64TrailingSeparatorA() {
        MacAddressUtil.parseMAC((String)"00-AA-11-FF-FE-BB-22-CC-");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseMacInvalidEUI64TrailingSeparatorB() {
        MacAddressUtil.parseMAC((String)"00:AA:11:FF:FE:BB:22:CC:");
    }
}

