/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ThreadDeathWatcher;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ThreadDeathWatcherTest {
    @Test(timeout=10000L)
    public void testWatch() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        };
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (!t.isAlive()) {
                    latch.countDown();
                }
            }
        };
        try {
            ThreadDeathWatcher.watch((Thread)t, (Runnable)task);
            Assert.fail((String)"must reject to watch a non-alive thread.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        t.start();
        ThreadDeathWatcher.watch((Thread)t, (Runnable)task);
        MatcherAssert.assertThat((Object)latch.await(750L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)false));
        t.interrupt();
        latch.await();
    }

    @Test(timeout=10000L)
    public void testUnwatch() throws Exception {
        final AtomicBoolean run = new AtomicBoolean();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
        };
        Runnable task = new Runnable(){

            @Override
            public void run() {
                run.set(true);
            }
        };
        t.start();
        ThreadDeathWatcher.watch((Thread)t, (Runnable)task);
        ThreadDeathWatcher.unwatch((Thread)t, (Runnable)task);
        t.interrupt();
        t.join();
        MatcherAssert.assertThat((Object)ThreadDeathWatcher.awaitInactivity((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)run.get(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(timeout=2000L)
    public void testThreadGroup() throws InterruptedException {
        ThreadGroup group = new ThreadGroup("group");
        final AtomicReference capturedGroup = new AtomicReference();
        Thread thread = new Thread(group, new Runnable(){

            @Override
            public void run() {
                Thread t = ThreadDeathWatcher.threadFactory.newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                capturedGroup.set(t.getThreadGroup());
            }
        });
        thread.start();
        thread.join();
        Assert.assertEquals((Object)group, capturedGroup.get());
    }
}

