/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class AbstractReferenceCountedTest {
    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainOverflow() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        referenceCounted.setRefCnt(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)referenceCounted.refCnt());
        referenceCounted.retain();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainOverflow2() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assert.assertEquals((long)1L, (long)referenceCounted.refCnt());
        referenceCounted.retain(Integer.MAX_VALUE);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReleaseOverflow() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        referenceCounted.setRefCnt(0);
        Assert.assertEquals((long)0L, (long)referenceCounted.refCnt());
        referenceCounted.release(Integer.MAX_VALUE);
    }

    @Test
    public void testReleaseErrorMessage() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assert.assertTrue((boolean)referenceCounted.release());
        try {
            referenceCounted.release(1);
            Assert.fail((String)"IllegalReferenceCountException didn't occur");
        }
        catch (IllegalReferenceCountException e) {
            Assert.assertEquals((Object)"refCnt: 0, decrement: 1", (Object)e.getMessage());
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainResurrect() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assert.assertTrue((boolean)referenceCounted.release());
        Assert.assertEquals((long)0L, (long)referenceCounted.refCnt());
        referenceCounted.retain();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainResurrect2() {
        AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
        Assert.assertTrue((boolean)referenceCounted.release());
        Assert.assertEquals((long)0L, (long)referenceCounted.refCnt());
        referenceCounted.retain(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRetainFromMultipleThreadsThrowsReferenceCountException() throws Exception {
        int threads = 4;
        ArrayDeque futures = new ArrayDeque(threads);
        ExecutorService service = Executors.newFixedThreadPool(threads);
        final AtomicInteger refCountExceptions = new AtomicInteger();
        try {
            for (int i = 0; i < 10000; ++i) {
                Future f;
                final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
                final CountDownLatch retainLatch = new CountDownLatch(1);
                Assert.assertTrue((boolean)referenceCounted.release());
                for (int a = 0; a < threads; ++a) {
                    final int retainCnt = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
                    futures.add(service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                retainLatch.await();
                                try {
                                    referenceCounted.retain(retainCnt);
                                }
                                catch (IllegalReferenceCountException e) {
                                    refCountExceptions.incrementAndGet();
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }));
                }
                retainLatch.countDown();
                while ((f = (Future)futures.poll()) != null) {
                    f.get();
                }
                Assert.assertEquals((long)4L, (long)refCountExceptions.get());
                refCountExceptions.set(0);
            }
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReleaseFromMultipleThreadsThrowsReferenceCountException() throws Exception {
        int threads = 4;
        ArrayDeque futures = new ArrayDeque(threads);
        ExecutorService service = Executors.newFixedThreadPool(threads);
        final AtomicInteger refCountExceptions = new AtomicInteger();
        try {
            for (int i = 0; i < 10000; ++i) {
                Future f;
                final AbstractReferenceCounted referenceCounted = AbstractReferenceCountedTest.newReferenceCounted();
                final CountDownLatch releaseLatch = new CountDownLatch(1);
                final AtomicInteger releasedCount = new AtomicInteger();
                for (int a = 0; a < threads; ++a) {
                    final AtomicInteger releaseCnt = new AtomicInteger(0);
                    futures.add(service.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                releaseLatch.await();
                                try {
                                    if (referenceCounted.release(releaseCnt.incrementAndGet())) {
                                        releasedCount.incrementAndGet();
                                    }
                                }
                                catch (IllegalReferenceCountException e) {
                                    refCountExceptions.incrementAndGet();
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }));
                }
                releaseLatch.countDown();
                while ((f = (Future)futures.poll()) != null) {
                    f.get();
                }
                Assert.assertEquals((long)3L, (long)refCountExceptions.get());
                Assert.assertEquals((long)1L, (long)releasedCount.get());
                refCountExceptions.set(0);
            }
        }
        finally {
            service.shutdown();
        }
    }

    private static AbstractReferenceCounted newReferenceCounted() {
        return new AbstractReferenceCounted(){

            protected void deallocate() {
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        };
    }
}

