/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.LocationAwareSlf4JLogger;
import io.netty.util.internal.logging.Slf4JLogger;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4JLoggerFactoryTest {
    @Test
    public void testCreation() {
        InternalLogger logger = Slf4JLoggerFactory.INSTANCE.newInstance("foo");
        Assert.assertTrue((logger instanceof Slf4JLogger || logger instanceof LocationAwareSlf4JLogger ? 1 : 0) != 0);
        Assert.assertEquals((Object)"foo", (Object)logger.name());
    }

    @Test
    public void testCreationLogger() {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logger.getName()).thenReturn((Object)"testlogger");
        InternalLogger internalLogger = Slf4JLoggerFactory.wrapLogger((Logger)logger);
        Assert.assertTrue((boolean)(internalLogger instanceof Slf4JLogger));
        Assert.assertEquals((Object)"testlogger", (Object)internalLogger.name());
    }

    @Test
    public void testCreationLocationAwareLogger() {
        Logger logger = (Logger)Mockito.mock(LocationAwareLogger.class);
        Mockito.when((Object)logger.getName()).thenReturn((Object)"testlogger");
        InternalLogger internalLogger = Slf4JLoggerFactory.wrapLogger((Logger)logger);
        Assert.assertTrue((boolean)(internalLogger instanceof LocationAwareSlf4JLogger));
        Assert.assertEquals((Object)"testlogger", (Object)internalLogger.name());
    }

    @Test
    public void testFormatMessage() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        LocationAwareLogger logger = (LocationAwareLogger)Mockito.mock(LocationAwareLogger.class);
        Mockito.when((Object)logger.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.isErrorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.isTraceEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.isWarnEnabled()).thenReturn((Object)true);
        Mockito.when((Object)logger.getName()).thenReturn((Object)"testlogger");
        InternalLogger internalLogger = Slf4JLoggerFactory.wrapLogger((Logger)logger);
        internalLogger.debug("{}", (Object)"debug");
        internalLogger.debug("{} {}", (Object)"debug1", (Object)"debug2");
        internalLogger.debug("{} {} {}", new Object[]{"debug1", "debug2", "debug3"});
        internalLogger.error("{}", (Object)"error");
        internalLogger.error("{} {}", (Object)"error1", (Object)"error2");
        internalLogger.error("{} {} {}", new Object[]{"error1", "error2", "error3"});
        internalLogger.info("{}", (Object)"info");
        internalLogger.info("{} {}", (Object)"info1", (Object)"info2");
        internalLogger.info("{} {} {}", new Object[]{"info1", "info2", "info3"});
        internalLogger.trace("{}", (Object)"trace");
        internalLogger.trace("{} {}", (Object)"trace1", (Object)"trace2");
        internalLogger.trace("{} {} {}", new Object[]{"trace1", "trace2", "trace3"});
        internalLogger.warn("{}", (Object)"warn");
        internalLogger.warn("{} {}", (Object)"warn1", (Object)"warn2");
        internalLogger.warn("{} {} {}", new Object[]{"warn1", "warn2", "warn3"});
        ((LocationAwareLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)3))).log((Marker)ArgumentMatchers.isNull(), (String)Mockito.eq((Object)LocationAwareSlf4JLogger.FQCN), Mockito.eq((int)10), (String)captor.capture(), (Object[])Mockito.any(Object[].class), (Throwable)ArgumentMatchers.isNull());
        ((LocationAwareLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)3))).log((Marker)ArgumentMatchers.isNull(), (String)Mockito.eq((Object)LocationAwareSlf4JLogger.FQCN), Mockito.eq((int)40), (String)captor.capture(), (Object[])Mockito.any(Object[].class), (Throwable)ArgumentMatchers.isNull());
        ((LocationAwareLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)3))).log((Marker)ArgumentMatchers.isNull(), (String)Mockito.eq((Object)LocationAwareSlf4JLogger.FQCN), Mockito.eq((int)20), (String)captor.capture(), (Object[])Mockito.any(Object[].class), (Throwable)ArgumentMatchers.isNull());
        ((LocationAwareLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)3))).log((Marker)ArgumentMatchers.isNull(), (String)Mockito.eq((Object)LocationAwareSlf4JLogger.FQCN), Mockito.eq((int)0), (String)captor.capture(), (Object[])Mockito.any(Object[].class), (Throwable)ArgumentMatchers.isNull());
        ((LocationAwareLogger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)3))).log((Marker)ArgumentMatchers.isNull(), (String)Mockito.eq((Object)LocationAwareSlf4JLogger.FQCN), Mockito.eq((int)30), (String)captor.capture(), (Object[])Mockito.any(Object[].class), (Throwable)ArgumentMatchers.isNull());
        Iterator logMessages = captor.getAllValues().iterator();
        Assert.assertEquals((Object)"debug", logMessages.next());
        Assert.assertEquals((Object)"debug1 debug2", logMessages.next());
        Assert.assertEquals((Object)"debug1 debug2 debug3", logMessages.next());
        Assert.assertEquals((Object)"error", logMessages.next());
        Assert.assertEquals((Object)"error1 error2", logMessages.next());
        Assert.assertEquals((Object)"error1 error2 error3", logMessages.next());
        Assert.assertEquals((Object)"info", logMessages.next());
        Assert.assertEquals((Object)"info1 info2", logMessages.next());
        Assert.assertEquals((Object)"info1 info2 info3", logMessages.next());
        Assert.assertEquals((Object)"trace", logMessages.next());
        Assert.assertEquals((Object)"trace1 trace2", logMessages.next());
        Assert.assertEquals((Object)"trace1 trace2 trace3", logMessages.next());
        Assert.assertEquals((Object)"warn", logMessages.next());
        Assert.assertEquals((Object)"warn1 warn2", logMessages.next());
        Assert.assertEquals((Object)"warn1 warn2 warn3", logMessages.next());
        Assert.assertFalse((boolean)logMessages.hasNext());
    }
}

