/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.CommonsLogger;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CommonsLoggerTest {
    private static final Exception e = new Exception();

    @Test
    public void testIsTraceEnabled() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)mockLog.isTraceEnabled()).thenReturn((Object)true);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        Assert.assertTrue((boolean)logger.isTraceEnabled());
        ((Log)Mockito.verify((Object)mockLog)).isTraceEnabled();
    }

    @Test
    public void testIsDebugEnabled() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)mockLog.isDebugEnabled()).thenReturn((Object)true);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        ((Log)Mockito.verify((Object)mockLog)).isDebugEnabled();
    }

    @Test
    public void testIsInfoEnabled() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)mockLog.isInfoEnabled()).thenReturn((Object)true);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        ((Log)Mockito.verify((Object)mockLog)).isInfoEnabled();
    }

    @Test
    public void testIsWarnEnabled() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)mockLog.isWarnEnabled()).thenReturn((Object)true);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        Assert.assertTrue((boolean)logger.isWarnEnabled());
        ((Log)Mockito.verify((Object)mockLog)).isWarnEnabled();
    }

    @Test
    public void testIsErrorEnabled() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)mockLog.isErrorEnabled()).thenReturn((Object)true);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        Assert.assertTrue((boolean)logger.isErrorEnabled());
        ((Log)Mockito.verify((Object)mockLog)).isErrorEnabled();
    }

    @Test
    public void testTrace() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.trace("a");
        ((Log)Mockito.verify((Object)mockLog)).trace((Object)"a");
    }

    @Test
    public void testTraceWithException() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.trace("a", (Throwable)e);
        ((Log)Mockito.verify((Object)mockLog)).trace((Object)"a", (Throwable)e);
    }

    @Test
    public void testDebug() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.debug("a");
        ((Log)Mockito.verify((Object)mockLog)).debug((Object)"a");
    }

    @Test
    public void testDebugWithException() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.debug("a", (Throwable)e);
        ((Log)Mockito.verify((Object)mockLog)).debug((Object)"a", (Throwable)e);
    }

    @Test
    public void testInfo() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.info("a");
        ((Log)Mockito.verify((Object)mockLog)).info((Object)"a");
    }

    @Test
    public void testInfoWithException() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.info("a", (Throwable)e);
        ((Log)Mockito.verify((Object)mockLog)).info((Object)"a", (Throwable)e);
    }

    @Test
    public void testWarn() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.warn("a");
        ((Log)Mockito.verify((Object)mockLog)).warn((Object)"a");
    }

    @Test
    public void testWarnWithException() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.warn("a", (Throwable)e);
        ((Log)Mockito.verify((Object)mockLog)).warn((Object)"a", (Throwable)e);
    }

    @Test
    public void testError() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.error("a");
        ((Log)Mockito.verify((Object)mockLog)).error((Object)"a");
    }

    @Test
    public void testErrorWithException() {
        Log mockLog = (Log)Mockito.mock(Log.class);
        CommonsLogger logger = new CommonsLogger(mockLog, "foo");
        logger.error("a", (Throwable)e);
        ((Log)Mockito.verify((Object)mockLog)).error((Object)"a", (Throwable)e);
    }
}

