/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class HashedWheelTimerTest {
    @Test
    public void testScheduleTimeoutShouldNotRunBeforeDelay() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch barrier = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                Assert.fail((String)"This should not have run");
                barrier.countDown();
            }
        }, 10L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)barrier.await(3L, TimeUnit.SECONDS));
        Assert.assertFalse((String)"timer should not expire", (boolean)timeout.isExpired());
        timer.stop();
    }

    @Test
    public void testScheduleTimeoutShouldRunAfterDelay() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch barrier = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                barrier.countDown();
            }
        }, 2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)barrier.await(3L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"timer should expire", (boolean)timeout.isExpired());
        timer.stop();
    }

    @Test(timeout=3000L)
    public void testStopTimer() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        HashedWheelTimer timerProcessed = new HashedWheelTimer();
        for (int i = 0; i < 3; ++i) {
            timerProcessed.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    latch.countDown();
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
        latch.await();
        Assert.assertEquals((String)"Number of unprocessed timeouts should be 0", (long)0L, (long)timerProcessed.stop().size());
        HashedWheelTimer timerUnprocessed = new HashedWheelTimer();
        for (int i = 0; i < 5; ++i) {
            timerUnprocessed.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                }
            }, 5L, TimeUnit.SECONDS);
        }
        Thread.sleep(1000L);
        Assert.assertFalse((String)"Number of unprocessed timeouts should be greater than 0", (boolean)timerUnprocessed.stop().isEmpty());
    }

    @Test(timeout=3000L)
    public void testTimerShouldThrowExceptionAfterShutdownForNewTimeouts() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        HashedWheelTimer timer = new HashedWheelTimer();
        for (int i = 0; i < 3; ++i) {
            timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    latch.countDown();
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
        latch.await();
        timer.stop();
        try {
            timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected exception didn't occur.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testTimerOverflowWheelLength() throws InterruptedException {
        final HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32);
        final CountDownLatch latch = new CountDownLatch(3);
        timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                timer.newTimeout((TimerTask)this, 100L, TimeUnit.MILLISECONDS);
                latch.countDown();
            }
        }, 100L, TimeUnit.MILLISECONDS);
        latch.await();
        Assert.assertFalse((boolean)timer.stop().isEmpty());
    }

    @Test
    public void testExecutionOnTime() throws InterruptedException {
        int i;
        int tickDuration = 200;
        int timeout = 125;
        int maxTimeout = 2 * (tickDuration + timeout);
        HashedWheelTimer timer = new HashedWheelTimer((long)tickDuration, TimeUnit.MILLISECONDS);
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        int scheduledTasks = 100000;
        for (i = 0; i < scheduledTasks; ++i) {
            final long start = System.nanoTime();
            timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    queue.add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < scheduledTasks; ++i) {
            long delay = (Long)queue.take();
            Assert.assertTrue((String)("Timeout + " + scheduledTasks + " delay " + delay + " must be " + timeout + " < " + maxTimeout), (delay >= (long)timeout && delay < (long)maxTimeout ? 1 : 0) != 0);
        }
        timer.stop();
    }

    @Test
    public void testRejectedExecutionExceptionWhenTooManyTimeoutsAreAddedBackToBack() {
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        try {
            timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Timer allowed adding 3 timeouts when maxPendingTimeouts was 2");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        finally {
            timer.stop();
        }
    }

    @Test
    public void testNewTimeoutShouldStopThrowingRejectedExecutionExceptionWhenExistingTimeoutIsCancelled() throws InterruptedException {
        int tickDurationMs = 100;
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        Timeout timeoutToCancel = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)timeoutToCancel.cancel());
        Thread.sleep(500L);
        CountDownLatch secondLatch = new CountDownLatch(1);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(secondLatch), 90L, TimeUnit.MILLISECONDS);
        secondLatch.await();
        timer.stop();
    }

    @Test(timeout=3000L)
    public void testNewTimeoutShouldStopThrowingRejectedExecutionExceptionWhenExistingTimeoutIsExecuted() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 25L, TimeUnit.MILLISECONDS, 4, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(latch), 90L, TimeUnit.MILLISECONDS);
        latch.await();
        CountDownLatch secondLatch = new CountDownLatch(1);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(secondLatch), 90L, TimeUnit.MILLISECONDS);
        secondLatch.await();
        timer.stop();
    }

    @Test
    public void reportPendingTimeouts() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        HashedWheelTimer timer = new HashedWheelTimer();
        Timeout t1 = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 100L, TimeUnit.MINUTES);
        Timeout t2 = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 100L, TimeUnit.MINUTES);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(latch), 90L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)timer.pendingTimeouts());
        t1.cancel();
        t2.cancel();
        latch.await();
        Assert.assertEquals((long)0L, (long)timer.pendingTimeouts());
        timer.stop();
    }

    @Test
    public void testOverflow() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch latch = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) {
                latch.countDown();
            }
        }, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
        timeout.cancel();
        timer.stop();
    }

    private static TimerTask createNoOpTimerTask() {
        return new TimerTask(){

            public void run(Timeout timeout) throws Exception {
            }
        };
    }

    private static TimerTask createCountDownLatchTimerTask(final CountDownLatch latch) {
        return new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                latch.countDown();
            }
        };
    }
}

