/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GlobalEventExecutorTest {
    private static final GlobalEventExecutor e = GlobalEventExecutor.INSTANCE;

    @Before
    public void setUp() throws Exception {
        while (GlobalEventExecutorTest.e.thread != null && GlobalEventExecutorTest.e.thread.isAlive()) {
            Thread.sleep(50L);
        }
    }

    @Test(timeout=5000L)
    public void testAutomaticStartStop() throws Exception {
        TestRunnable task = new TestRunnable(500L);
        e.execute((Runnable)task);
        Thread thread = GlobalEventExecutorTest.e.thread;
        Assert.assertThat((Object)thread, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)thread.isAlive(), (Matcher)CoreMatchers.is((Object)true));
        thread.join();
        Assert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        task.ran.set(false);
        e.execute((Runnable)task);
        Assert.assertThat((Object)GlobalEventExecutorTest.e.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)thread)));
        thread = GlobalEventExecutorTest.e.thread;
        thread.join();
        Assert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(timeout=5000L)
    public void testScheduledTasks() throws Exception {
        TestRunnable task = new TestRunnable(0L);
        ScheduledFuture f = e.schedule((Runnable)task, 1500L, TimeUnit.MILLISECONDS);
        f.sync();
        Assert.assertThat((Object)task.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        Thread thread = GlobalEventExecutorTest.e.thread;
        Assert.assertThat((Object)thread, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)thread.isAlive(), (Matcher)CoreMatchers.is((Object)true));
        thread.join();
    }

    @Test(timeout=2000L)
    public void testThreadGroup() throws InterruptedException {
        ThreadGroup group = new ThreadGroup("group");
        final AtomicReference capturedGroup = new AtomicReference();
        Thread thread = new Thread(group, new Runnable(){

            @Override
            public void run() {
                Thread t = e.threadFactory.newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                capturedGroup.set(t.getThreadGroup());
            }
        });
        thread.start();
        thread.join();
        Assert.assertEquals((Object)group, capturedGroup.get());
    }

    @Test(timeout=5000L)
    public void testTakeTask() throws Exception {
        TestRunnable beforeTask = new TestRunnable(0L);
        e.execute((Runnable)beforeTask);
        TestRunnable scheduledTask = new TestRunnable(0L);
        ScheduledFuture f = e.schedule((Runnable)scheduledTask, 1500L, TimeUnit.MILLISECONDS);
        TestRunnable afterTask = new TestRunnable(0L);
        e.execute((Runnable)afterTask);
        f.sync();
        Assert.assertThat((Object)beforeTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)scheduledTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)afterTask.ran.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testTakeTaskAlwaysHasTask() throws Exception {
        TestRunnable t = new TestRunnable(0L);
        ScheduledFuture f = e.schedule((Runnable)t, 1500L, TimeUnit.MILLISECONDS);
        final Runnable doNothing = new Runnable(){

            @Override
            public void run() {
            }
        };
        final AtomicBoolean stop = new AtomicBoolean(false);
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!stop.get()) {
                        e.execute(doNothing);
                    }
                }
            }).start();
            f.sync();
            Assert.assertThat((Object)t.ran.get(), (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            stop.set(true);
        }
    }

    private static final class TestRunnable
    implements Runnable {
        final AtomicBoolean ran = new AtomicBoolean();
        final long delay;

        TestRunnable(long delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.ran.set(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

