/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class NativeLibraryLoaderTest {
    @Test
    public void testFileNotFound() {
        block2: {
            try {
                NativeLibraryLoader.load((String)UUID.randomUUID().toString(), (ClassLoader)NativeLibraryLoaderTest.class.getClassLoader());
                Assert.fail();
            }
            catch (UnsatisfiedLinkError error) {
                Assert.assertTrue((boolean)(error.getCause() instanceof FileNotFoundException));
                if (PlatformDependent.javaVersion() < 7) break block2;
                NativeLibraryLoaderTest.verifySuppressedException(error, UnsatisfiedLinkError.class);
            }
        }
    }

    @Test
    public void testFileNotFoundWithNullClassLoader() {
        block2: {
            try {
                NativeLibraryLoader.load((String)UUID.randomUUID().toString(), null);
                Assert.fail();
            }
            catch (UnsatisfiedLinkError error) {
                Assert.assertTrue((boolean)(error.getCause() instanceof FileNotFoundException));
                if (PlatformDependent.javaVersion() < 7) break block2;
                NativeLibraryLoaderTest.verifySuppressedException(error, ClassNotFoundException.class);
            }
        }
    }

    @SuppressJava6Requirement(reason="uses Java 7+ Throwable#getSuppressed but is guarded by version checks")
    private static void verifySuppressedException(UnsatisfiedLinkError error, Class<?> expectedSuppressedExceptionClass) {
        try {
            Throwable[] suppressed = error.getCause().getSuppressed();
            Assert.assertTrue((suppressed.length == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(suppressed[0] instanceof UnsatisfiedLinkError));
            suppressed = suppressed[0].getSuppressed();
            Assert.assertTrue((suppressed.length == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)expectedSuppressedExceptionClass.isInstance(suppressed[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testPatchingId() throws IOException {
        NativeLibraryLoaderTest.testPatchingId0(true, false);
    }

    @Test
    public void testPatchingIdWithOsArch() throws IOException {
        NativeLibraryLoaderTest.testPatchingId0(true, true);
    }

    @Test
    public void testPatchingIdNotMatch() throws IOException {
        NativeLibraryLoaderTest.testPatchingId0(false, false);
    }

    @Test
    public void testPatchingIdWithOsArchNotMatch() throws IOException {
        NativeLibraryLoaderTest.testPatchingId0(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testPatchingId0(boolean match, boolean withOsArch) throws IOException {
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        byte[] idBytes = "/workspace/netty-tcnative/boringssl-static/target/native-build/target/lib/libnetty_tcnative-2.0.20.Final.jnilib".getBytes(CharsetUtil.UTF_8);
        String originalName = match ? "netty-tcnative" : "nonexist_tcnative";
        String name = "shaded_" + originalName;
        if (withOsArch) {
            name = name + "_osx_x86_64";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(bytes, 0, bytes.length);
        out.write(idBytes, 0, idBytes.length);
        out.write(bytes, 0, bytes.length);
        out.flush();
        byte[] inBytes = out.toByteArray();
        out.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Assert.assertEquals((Object)match, (Object)NativeLibraryLoader.patchShadedLibraryId((InputStream)inputStream, (OutputStream)outputStream, (String)originalName, (String)name));
            outputStream.flush();
            byte[] outputBytes = outputStream.toByteArray();
            Assert.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOfRange(outputBytes, 0, bytes.length));
            byte[] patchedId = Arrays.copyOfRange(outputBytes, bytes.length, bytes.length + idBytes.length);
            Assert.assertEquals((Object)(!match ? 1 : 0), (Object)Arrays.equals(idBytes, patchedId));
            Assert.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOfRange(outputBytes, bytes.length + idBytes.length, outputBytes.length));
            Assert.assertEquals((long)inBytes.length, (long)outputBytes.length);
        }
        finally {
            ((InputStream)inputStream).close();
            outputStream.close();
        }
    }
}

