/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AbstractScheduledEventExecutorTest {
    private static final Runnable TEST_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Callable<?> TEST_CALLABLE = Executors.callable(TEST_RUNNABLE);

    @Test
    public void testScheduleRunnableZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_RUNNABLE, 0L, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assert.assertNotNull((Object)executor.pollScheduledTask());
        Assert.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleRunnableNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_RUNNABLE, -1L, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assert.assertNotNull((Object)executor.pollScheduledTask());
        Assert.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleCallableZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_CALLABLE, 0L, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assert.assertNotNull((Object)executor.pollScheduledTask());
        Assert.assertNull((Object)executor.pollScheduledTask());
    }

    @Test
    public void testScheduleCallableNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        ScheduledFuture future = executor.schedule(TEST_CALLABLE, -1L, TimeUnit.NANOSECONDS);
        Assert.assertEquals((long)0L, (long)future.getDelay(TimeUnit.NANOSECONDS));
        Assert.assertNotNull((Object)executor.pollScheduledTask());
        Assert.assertNull((Object)executor.pollScheduledTask());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleAtFixedRateRunnableZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        executor.scheduleAtFixedRate(TEST_RUNNABLE, 0L, 0L, TimeUnit.DAYS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleAtFixedRateRunnableNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        executor.scheduleAtFixedRate(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleWithFixedDelayZero() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        executor.scheduleWithFixedDelay(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleWithFixedDelayNegative() {
        TestScheduledEventExecutor executor = new TestScheduledEventExecutor();
        executor.scheduleWithFixedDelay(TEST_RUNNABLE, 0L, -1L, TimeUnit.DAYS);
    }

    private static final class TestScheduledEventExecutor
    extends AbstractScheduledEventExecutor {
        private TestScheduledEventExecutor() {
        }

        public boolean isShuttingDown() {
            return false;
        }

        public boolean inEventLoop(Thread thread) {
            return true;
        }

        public void shutdown() {
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public Future<?> terminationFuture() {
            throw new UnsupportedOperationException();
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return false;
        }

        public void execute(Runnable command) {
            throw new UnsupportedOperationException();
        }
    }
}

