/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.DefaultPriorityQueue;
import io.netty.util.internal.PriorityQueue;
import io.netty.util.internal.PriorityQueueNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPriorityQueueTest {
    @Test
    public void testPoll() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(7);
        TestElement e = new TestElement(6);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assert.assertSame((Object)c, (Object)queue.peek());
        Assert.assertSame((Object)c, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assert.assertEquals((long)4L, (long)queue.size());
        Assert.assertSame((Object)a, (Object)queue.peek());
        Assert.assertSame((Object)a, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
        Assert.assertSame((Object)e, (Object)queue.peek());
        Assert.assertSame((Object)e, (Object)queue.poll());
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertSame((Object)d, (Object)queue.peek());
        Assert.assertSame((Object)d, (Object)queue.poll());
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertSame((Object)b, (Object)queue.peek());
        Assert.assertSame((Object)b, (Object)queue.poll());
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testClear() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        queue.clear();
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        Assert.assertSame((Object)a, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        Assert.assertSame((Object)a, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        Assert.assertSame((Object)c, (Object)queue.peek());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assert.assertSame((Object)c, (Object)queue.peek());
    }

    @Test
    public void testClearIgnoringIndexes() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        TestElement e = new TestElement(11);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        queue.clearIgnoringIndexes();
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        try {
            queue.offer((Object)a);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assert.assertSame((Object)e, (Object)queue.peek());
    }

    @Test
    public void testRemoval() {
        DefaultPriorityQueueTest.testRemoval(false);
    }

    @Test
    public void testRemovalTyped() {
        DefaultPriorityQueueTest.testRemoval(true);
    }

    private static void testRemoval(boolean typed) {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 4);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(5);
        TestElement b = new TestElement(10);
        TestElement c = new TestElement(2);
        TestElement d = new TestElement(6);
        TestElement notInQueue = new TestElement(-1);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, a);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, c);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, d);
        Assert.assertFalse((boolean)(typed ? queue.removeTyped((Object)notInQueue) : queue.remove((Object)notInQueue)));
        Assert.assertSame((Object)c, (Object)queue.peek());
        Assert.assertEquals((long)4L, (long)queue.size());
        Assert.assertTrue((boolean)(typed ? queue.removeTyped((Object)b) : queue.remove((Object)b)));
        Assert.assertSame((Object)c, (Object)queue.peek());
        Assert.assertEquals((long)3L, (long)queue.size());
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, b);
        Assert.assertSame((Object)c, (Object)queue.peek());
        Assert.assertEquals((long)4L, (long)queue.size());
        Assert.assertTrue((boolean)(typed ? queue.removeTyped((Object)b) : queue.remove((Object)b)));
        Assert.assertSame((Object)c, (Object)queue.peek());
        Assert.assertEquals((long)3L, (long)queue.size());
        Assert.assertTrue((boolean)(typed ? queue.removeTyped((Object)c) : queue.remove((Object)c)));
        Assert.assertSame((Object)a, (Object)queue.peek());
        Assert.assertEquals((long)2L, (long)queue.size());
        Assert.assertTrue((boolean)(typed ? queue.removeTyped((Object)a) : queue.remove((Object)a)));
        Assert.assertSame((Object)d, (Object)queue.peek());
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertTrue((boolean)(typed ? queue.removeTyped((Object)d) : queue.remove((Object)d)));
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testZeroInitialSize() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement e = new TestElement(1);
        DefaultPriorityQueueTest.assertOffer((PriorityQueue<TestElement>)queue, e);
        Assert.assertSame((Object)e, (Object)queue.peek());
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        Assert.assertSame((Object)e, (Object)queue.poll());
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
    }

    @Test
    public void testPriorityChange() {
        DefaultPriorityQueue queue = new DefaultPriorityQueue((Comparator)TestElementComparator.INSTANCE, 0);
        DefaultPriorityQueueTest.assertEmptyQueue((PriorityQueue<TestElement>)queue);
        TestElement a = new TestElement(10);
        TestElement b = new TestElement(20);
        TestElement c = new TestElement(30);
        TestElement d = new TestElement(25);
        TestElement e = new TestElement(23);
        TestElement f = new TestElement(15);
        queue.add((Object)a);
        queue.add((Object)b);
        queue.add((Object)c);
        queue.add((Object)d);
        queue.add((Object)e);
        queue.add((Object)f);
        e.value = 35;
        queue.priorityChanged((Object)e);
        a.value = 40;
        queue.priorityChanged((Object)a);
        a.value = 31;
        queue.priorityChanged((Object)a);
        d.value = 10;
        queue.priorityChanged((Object)d);
        f.value = 5;
        queue.priorityChanged((Object)f);
        ArrayList<TestElement> expectedOrderList = new ArrayList<TestElement>(queue.size());
        expectedOrderList.addAll(Arrays.asList(a, b, c, d, e, f));
        Collections.sort(expectedOrderList, TestElementComparator.INSTANCE);
        Assert.assertEquals((long)expectedOrderList.size(), (long)queue.size());
        Assert.assertEquals((Object)expectedOrderList.isEmpty(), (Object)queue.isEmpty());
        Iterator itr = expectedOrderList.iterator();
        while (itr.hasNext()) {
            TestElement next = (TestElement)itr.next();
            TestElement poll = (TestElement)queue.poll();
            Assert.assertEquals((Object)next, (Object)poll);
            itr.remove();
            Assert.assertEquals((long)expectedOrderList.size(), (long)queue.size());
            Assert.assertEquals((Object)expectedOrderList.isEmpty(), (Object)queue.isEmpty());
        }
    }

    private static void assertOffer(PriorityQueue<TestElement> queue, TestElement a) {
        Assert.assertTrue((boolean)queue.offer((Object)a));
        Assert.assertTrue((boolean)queue.contains((Object)a));
        Assert.assertTrue((boolean)queue.containsTyped((Object)a));
        try {
            queue.offer((Object)a);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertEmptyQueue(PriorityQueue<TestElement> queue) {
        Assert.assertNull((Object)queue.peek());
        Assert.assertNull((Object)queue.poll());
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    private static final class TestElement
    implements PriorityQueueNode {
        int value;
        private int priorityQueueIndex = -1;

        TestElement(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof TestElement && ((TestElement)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public int priorityQueueIndex(DefaultPriorityQueue queue) {
            return this.priorityQueueIndex;
        }

        public void priorityQueueIndex(DefaultPriorityQueue queue, int i) {
            this.priorityQueueIndex = i;
        }
    }

    private static final class TestElementComparator
    implements Comparator<TestElement>,
    Serializable {
        private static final long serialVersionUID = 7930368853384760103L;
        static final TestElementComparator INSTANCE = new TestElementComparator();

        private TestElementComparator() {
        }

        @Override
        public int compare(TestElement o1, TestElement o2) {
            return o1.value - o2.value;
        }
    }
}

