/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.UnorderedThreadPoolEventExecutor;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;

public class UnorderedThreadPoolEventExecutorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotEndlessExecute() throws Exception {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        try {
            final CountDownLatch latch = new CountDownLatch(3);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            };
            executor.execute(task);
            Future future = executor.submit(task).addListener((GenericFutureListener)new FutureListener<Object>(){

                public void operationComplete(Future<Object> future) throws Exception {
                    latch.countDown();
                }
            });
            latch.await();
            future.syncUninterruptibly();
            for (int i = 0; i < 10000; ++i) {
                Assert.assertTrue((boolean)executor.getQueue().isEmpty());
            }
        }
        finally {
            executor.shutdownGracefully();
        }
    }
}

