/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.security.Permission;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class DefaultThreadFactoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=2000L)
    public void testDescendantThreadGroups() throws InterruptedException {
        SecurityManager current = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkAccess(ThreadGroup g) {
                    ThreadGroup source = Thread.currentThread().getThreadGroup();
                    if (source != null) {
                        if (!source.parentOf(g)) {
                            throw new SecurityException("source group is not an ancestor of the target group");
                        }
                        super.checkAccess(g);
                    }
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            final AtomicReference factory = new AtomicReference();
            final AtomicInteger counter = new AtomicInteger();
            final Runnable task = new Runnable(){

                @Override
                public void run() {
                    counter.incrementAndGet();
                }
            };
            final AtomicReference interrupted = new AtomicReference();
            Thread first = new Thread(new ThreadGroup("brother"), new Runnable(){

                @Override
                public void run() {
                    factory.set(new DefaultThreadFactory("test", false, 5, null));
                    Thread t = ((DefaultThreadFactory)factory.get()).newThread(task);
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        interrupted.set(e);
                        Thread.currentThread().interrupt();
                    }
                }
            });
            first.start();
            first.join();
            Assert.assertNull(interrupted.get());
            Thread second = new Thread(new ThreadGroup("sister"), new Runnable(){

                @Override
                public void run() {
                    Thread t = ((DefaultThreadFactory)factory.get()).newThread(task);
                    t.start();
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        interrupted.set(e);
                        Thread.currentThread().interrupt();
                    }
                }
            });
            second.start();
            second.join();
            Assert.assertNull(interrupted.get());
            Assert.assertEquals((long)2L, (long)counter.get());
        }
        finally {
            System.setSecurityManager(current);
        }
    }

    @Test(timeout=2000L)
    public void testDefaultThreadFactoryStickyThreadGroupConstructor() throws InterruptedException {
        final ThreadGroup sticky = new ThreadGroup("sticky");
        DefaultThreadFactoryTest.runStickyThreadGroupTest(new Callable<DefaultThreadFactory>(){

            @Override
            public DefaultThreadFactory call() throws Exception {
                return new DefaultThreadFactory("test", false, 5, sticky);
            }
        }, sticky);
    }

    @Test(timeout=2000L)
    public void testDefaultThreadFactoryInheritsThreadGroup() throws InterruptedException {
        final ThreadGroup sticky = new ThreadGroup("sticky");
        DefaultThreadFactoryTest.runStickyThreadGroupTest(new Callable<DefaultThreadFactory>(){

            @Override
            public DefaultThreadFactory call() throws Exception {
                final AtomicReference factory = new AtomicReference();
                Thread thread = new Thread(sticky, new Runnable(){

                    @Override
                    public void run() {
                        factory.set(new DefaultThreadFactory("test"));
                    }
                });
                thread.start();
                thread.join();
                return (DefaultThreadFactory)factory.get();
            }
        }, sticky);
    }

    @Test(timeout=2000L)
    public void testDefaultThreadFactoryInheritsThreadGroupFromSecurityManager() throws InterruptedException {
        SecurityManager current = System.getSecurityManager();
        try {
            final ThreadGroup sticky = new ThreadGroup("sticky");
            System.setSecurityManager(new SecurityManager(){

                @Override
                public ThreadGroup getThreadGroup() {
                    return sticky;
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            DefaultThreadFactoryTest.runStickyThreadGroupTest(new Callable<DefaultThreadFactory>(){

                @Override
                public DefaultThreadFactory call() throws Exception {
                    return new DefaultThreadFactory("test");
                }
            }, sticky);
        }
        finally {
            System.setSecurityManager(current);
        }
    }

    private static void runStickyThreadGroupTest(final Callable<DefaultThreadFactory> callable, ThreadGroup expected) throws InterruptedException {
        final AtomicReference captured = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        Thread first = new Thread(new ThreadGroup("wrong"), new Runnable(){

            @Override
            public void run() {
                DefaultThreadFactory factory;
                try {
                    factory = (DefaultThreadFactory)callable.call();
                }
                catch (Exception e) {
                    exception.set(e);
                    throw new RuntimeException(e);
                }
                Thread t = factory.newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                captured.set(t.getThreadGroup());
            }
        });
        first.start();
        first.join();
        Assert.assertNull(exception.get());
        Assert.assertEquals((Object)expected, captured.get());
    }

    @Test(timeout=2000L)
    public void testDefaultThreadFactoryNonStickyThreadGroupConstructor() throws InterruptedException {
        final AtomicReference factory = new AtomicReference();
        final AtomicReference firstCaptured = new AtomicReference();
        ThreadGroup firstGroup = new ThreadGroup("first");
        Thread first = new Thread(firstGroup, new Runnable(){

            @Override
            public void run() {
                factory.set(new DefaultThreadFactory("sticky", false, 5, null));
                Thread t = ((DefaultThreadFactory)factory.get()).newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                firstCaptured.set(t.getThreadGroup());
            }
        });
        first.start();
        first.join();
        Assert.assertEquals((Object)firstGroup, firstCaptured.get());
        final AtomicReference secondCaptured = new AtomicReference();
        ThreadGroup secondGroup = new ThreadGroup("second");
        Thread second = new Thread(secondGroup, new Runnable(){

            @Override
            public void run() {
                Thread t = ((DefaultThreadFactory)factory.get()).newThread(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                secondCaptured.set(t.getThreadGroup());
            }
        });
        second.start();
        second.join();
        Assert.assertEquals((Object)secondGroup, secondCaptured.get());
    }
}

