/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

public class ByteString {
    private static final ByteStringFactory DEFAULT_FACTORY = new ByteStringFactory(){

        @Override
        public ByteString newInstance(byte[] value, int start, int length, boolean copy) {
            return new ByteString(value, start, length, copy);
        }
    };
    public static final ByteString EMPTY_STRING = new ByteString(0);
    protected static final int HASH_CODE_PRIME = 31;
    protected final byte[] value;
    private final int offset;
    private final int length;
    private int hash;

    ByteString(int length) {
        this.value = new byte[length];
        this.offset = 0;
        this.length = length;
    }

    public ByteString(byte[] value) {
        this(value, true);
    }

    public ByteString(byte[] value, boolean copy) {
        this(value, 0, ObjectUtil.checkNotNull(value, "value").length, copy);
    }

    public ByteString(byte[] value, int start, int length, boolean copy) {
        if (copy) {
            this.value = Arrays.copyOfRange(value, start, start + length);
            this.offset = 0;
            this.length = length;
        } else {
            if (start < 0 || start > value.length - length) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
            }
            this.value = value;
            this.offset = start;
            this.length = length;
        }
    }

    public ByteString(ByteString value, boolean copy) {
        ObjectUtil.checkNotNull(value, "value");
        this.length = value.length();
        this.hash = value.hash;
        if (copy) {
            this.value = new byte[this.length];
            System.arraycopy(value.array(), value.arrayOffset(), this.value, 0, this.length);
            this.offset = 0;
        } else {
            this.value = value.array();
            this.offset = value.offset;
        }
    }

    public ByteString(ByteBuffer value) {
        this(value, true);
    }

    public ByteString(ByteBuffer value, boolean copy) {
        this(value, value.position(), ObjectUtil.checkNotNull(value, "value").remaining(), copy);
    }

    public ByteString(ByteBuffer value, int start, int length, boolean copy) {
        if (start < 0 || length > ObjectUtil.checkNotNull(value, "value").capacity() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= value.capacity(" + value.capacity() + ')');
        }
        if (value.hasArray()) {
            if (copy) {
                int bufferOffset = value.arrayOffset() + start;
                this.value = Arrays.copyOfRange(value.array(), bufferOffset, bufferOffset + length);
                this.offset = 0;
                this.length = length;
            } else {
                this.value = value.array();
                this.offset = start;
                this.length = length;
            }
        } else {
            this.value = new byte[length];
            int oldPos = value.position();
            value.get(this.value, 0, length);
            value.position(oldPos);
            this.offset = 0;
            this.length = length;
        }
    }

    public ByteString(char[] value, Charset charset) {
        this(value, charset, 0, ObjectUtil.checkNotNull(value, "value").length);
    }

    public ByteString(char[] value, Charset charset, int start, int length) {
        if (start < 0 || length > ObjectUtil.checkNotNull(value, "value").length - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= length(" + length + ')');
        }
        CharBuffer cbuf = CharBuffer.wrap(value, start, start + length);
        CharsetEncoder encoder = CharsetUtil.getEncoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int bufferOffset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), bufferOffset, bufferOffset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public ByteString(CharSequence value, Charset charset) {
        this(value, charset, 0, ObjectUtil.checkNotNull(value, "value").length());
    }

    public ByteString(CharSequence value, Charset charset, int start, int length) {
        if (start < 0 || length > ObjectUtil.checkNotNull(value, "value").length() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= length(" + value.length() + ')');
        }
        CharBuffer cbuf = CharBuffer.wrap(value, start, start + length);
        CharsetEncoder encoder = CharsetUtil.getEncoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int offset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), offset, offset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public static final ByteString fromAscii(CharSequence value) {
        return new ByteString(value, CharsetUtil.US_ASCII);
    }

    public final int forEachByte(ByteProcessor visitor) throws Exception {
        return this.forEachByte0(0, this.length(), visitor);
    }

    public final int forEachByte(int index, int length, ByteProcessor visitor) throws Exception {
        if (index < 0 || length > this.length() - index) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(index, length, visitor);
    }

    private int forEachByte0(int index, int length, ByteProcessor visitor) throws Exception {
        int len = this.offset + length;
        for (int i = this.offset + index; i < len; ++i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public final int forEachByteDesc(ByteProcessor visitor) throws Exception {
        return this.forEachByteDesc0(0, this.length(), visitor);
    }

    public final int forEachByteDesc(int index, int length, ByteProcessor visitor) throws Exception {
        if (index < 0 || length > this.length() - index) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(index, length, visitor);
    }

    private int forEachByteDesc0(int index, int length, ByteProcessor visitor) throws Exception {
        int end = this.offset + index;
        for (int i = this.offset + index + length - 1; i >= end; --i) {
            if (visitor.process(this.value[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public final byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        return this.value[index + this.offset];
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    public final int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.hash = 0;
    }

    public final byte[] array() {
        return this.value;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public final byte[] toByteArray(int start, int end) {
        return Arrays.copyOfRange(this.value, start + this.offset, end + this.offset);
    }

    public final void copy(int srcIdx, byte[] dst, int dstIdx, int length) {
        if (srcIdx < 0 || length > this.length() - srcIdx) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, srcIdx + this.offset, ObjectUtil.checkNotNull(dst, "dst"), dstIdx, length);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int end = this.offset + this.length;
            for (int i = this.offset; i < end; ++i) {
                h = h * 31 + this.value[i];
            }
            this.hash = h;
        }
        return this.hash;
    }

    public ByteString subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    public ByteString subSequence(int start, int end) {
        return this.subSequence(start, end, true);
    }

    public ByteString subSequence(int start, int end, boolean copy) {
        return this.subSequence(start, end, copy, DEFAULT_FACTORY);
    }

    protected ByteString subSequence(int start, int end, boolean copy, ByteStringFactory factory) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (end == start) {
            return EMPTY_STRING;
        }
        return factory.newInstance(this.value, start + this.offset, end - start, copy);
    }

    public final int parseAsciiInt() {
        return this.parseAsciiInt(0, this.length(), 10);
    }

    public final int parseAsciiInt(int radix) {
        return this.parseAsciiInt(0, this.length(), radix);
    }

    public final int parseAsciiInt(int start, int end) {
        return this.parseAsciiInt(start, end, 10);
    }

    public final int parseAsciiInt(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return this.parseAsciiInt(i, end, radix, negative);
    }

    private int parseAsciiInt(int start, int end, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result;
    }

    public final long parseAsciiLong() {
        return this.parseAsciiLong(0, this.length(), 10);
    }

    public final long parseAsciiLong(int radix) {
        return this.parseAsciiLong(0, this.length(), radix);
    }

    public final long parseAsciiLong(int start, int end) {
        return this.parseAsciiLong(start, end, 10);
    }

    public final long parseAsciiLong(int start, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start == end) {
            throw new NumberFormatException();
        }
        int i = start;
        boolean bl = negative = this.byteAt(i) == 45;
        if (negative && ++i == end) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return this.parseAsciiLong(i, end, radix, negative);
    }

    private long parseAsciiLong(int start, int end, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        int currOffset = start;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            if (max > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(this.subSequence(start, end, false).toString());
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result;
    }

    public final char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int start) {
        if (start + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + start + " would go out of bounds.");
        }
        int startWithOffset = start + this.offset;
        return (char)((this.value[startWithOffset] & 0xFF) << 8 | this.value[startWithOffset + 1] & 0xFF);
    }

    public final short parseAsciiShort() {
        return this.parseAsciiShort(0, this.length(), 10);
    }

    public final short parseAsciiShort(int radix) {
        return this.parseAsciiShort(0, this.length(), radix);
    }

    public final short parseAsciiShort(int start, int end) {
        return this.parseAsciiShort(start, end, 10);
    }

    public final short parseAsciiShort(int start, int end, int radix) {
        int intValue = this.parseAsciiInt(start, end, radix);
        short result = (short)intValue;
        if (result != intValue) {
            throw new NumberFormatException(this.subSequence(start, end, false).toString());
        }
        return result;
    }

    public final float parseAsciiFloat() {
        return this.parseAsciiFloat(0, this.length());
    }

    public final float parseAsciiFloat(int start, int end) {
        return Float.parseFloat(this.toString(start, end));
    }

    public final double parseAsciiDouble() {
        return this.parseAsciiDouble(0, this.length());
    }

    public final double parseAsciiDouble(int start, int end) {
        return Double.parseDouble(this.toString(start, end));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteString)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ByteString other = (ByteString)obj;
        return this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), this.arrayOffset() + this.length(), other.array(), other.arrayOffset(), other.arrayOffset() + other.length());
    }

    public String toString() {
        return this.toString(0, this.length());
    }

    public final String toString(Charset charset) {
        return this.toString(charset, 0, this.length());
    }

    public final String toString(int start, int end) {
        return this.toString(CharsetUtil.ISO_8859_1, start, end);
    }

    public String toString(Charset charset, int start, int end) {
        int length = end - start;
        if (length == 0) {
            return "";
        }
        if (start < 0 || length > this.length() - start) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        return new String(this.value, start + this.offset, length, charset);
    }

    protected static interface ByteStringFactory {
        public ByteString newInstance(byte[] var1, int var2, int var3, boolean var4);
    }
}

